<?xml version='1.0'?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'default'"/>
	

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a single table element
	(<td>) for inclusion in a table of movie recommendations.
-->
<xsl:template match="/MOVIE">
	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>
	Average Rating : </b><xsl:value-of select="$aveRating"/>
				<img name="button" src="images/want_null.gif" width="153" height="15" border="0" alt="want">
									<xsl:attribute name="name">button<xsl:value-of select="$movieNum"/></xsl:attribute>
									<xsl:attribute name="usemap">#radiobutton<xsl:value-of select="$movieNum"/></xsl:attribute>
								</img>
							</b></span>
						</td>
					</tr>
					</table><!--End ratings  table w=190-->
				</td>
			</tr>
			<tr> 
				<td colspan="2" height="20" valign="top">
					<span id="movieDesc">
						<xsl:variable name="moviedesc">
							<xsl:apply-templates select="//NOTES" mode="movieDescription"/>
						</xsl:variable>
						<xsl:value-of select="substring($moviedesc,0,100)"/>...
					<b><a id="movieLink"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute><span id="tinytext">read more&gt;&gt;</span></a></b>
					</span>
				</td>
			</tr>
			</table>
		</td>
</xsl:template>

</xsl:stylesheet>


